<?php
/**
 * @copyright    Copyright (C) 2009 Nicholas K. Dionysopoulos. All rights reserved.
 * @author		Aazam
 * @license      GNU/GPL v.2 or later
 * 
 * flexicontentlinks is free software. This version may have been modified pursuant
 * to the GNU General Public License, and as distributed it includes or
 * is derivative of works licensed under the GNU General Public License or
 * other free or open source software licenses.
 *
 * Based on "joomlalinks" found in JCE's core distribution, and flexicontentlinks by Emmanuel Dannan and Ryan Demmer
 */

defined( '_WF_EXT' ) or die( 'ERROR_403' );


class FlexicontentlinksTags extends JObject
{
	var $_option = 'com_flexicontent_tags';
	
	/**
	* Constructor activating the default information of the class
	*
	* @access	protected
	*/
	function __construct($options = array()){
	}

	/**
	 * Returns a reference to a editor object
	 *
	 * This method must be invoked as:
	 * 		<pre>  $browser =JContentEditor::getInstance();</pre>
	 *
	 * @access	public
	 * @return	JCE  The editor object.
	 * @since	1.5
	 */
	function &getInstance()
	{
		static $instance;

		if ( !is_object( $instance ) ){
			$instance = new FlexicontentlinksTags();
		}
		return $instance;
	}
	
	public function getOption()
	{
		return $this->_option;
	}
	
//	public function getTask()
//	{
//		return $this->_task;
//	}
	
	public function getList()
	{
		$advlink = WFEditorPlugin::getInstance();
		$list = '';
		if ($advlink->checkAccess('flexicontentlinks.tags', '1')) {
			return  '<li id="index.php?option=com_flexicontent_tags&view=tags"><div class="tree-row"><div class="tree-image"></div><span class="folderflexitags nolink"><a href="javascript:;">' . JText::_('FLEXIcontent tags') . '</a></span></div></li>';
		}
		return $list;	
	}
	
	
	public function getLinks($args)
	{		
		$view		= isset($args->view) ? $args->view : '';
		if (!$view='tags') {return array();}
		
		$items 	= array();
		
		require_once(JPATH_SITE .DS. 'components' .DS. 'com_flexicontent' .DS. 'helpers' .DS. 'route.php');

		$db		=& JFactory::getDBO();
		$query	= $db->getQuery(true);
		$query->clear();
		$query->select('t.name, t.id, CASE WHEN CHAR_LENGTH(t.alias) THEN CONCAT_WS(\':\', t.id, t.alias) ELSE t.id END as slug ');
		$query->from('#__flexicontent_tags AS t ');
		$query->where('t.published = 1 ');
		$query->order('t.name ASC');
		$db->setQuery($query);
		$tags = $db->loadObjectList();


		foreach ($tags as $tag) {
			$items[] = array(
			
				'id'		=>	FlexicontentHelperRoute::getTagRoute($tag->slug),
				//'url' => FlexicontentHelperRoute::getTagRoute($tag->slug),
				'name'		=>	$tag->name,
				'class'		=>	'fileflexitag'
			);
		}
		
		return $items;
	}
}
?>